package com.logicbig.example;

import org.primefaces.context.RequestContext;
import org.primefaces.event.SelectEvent;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ViewScoped;
import javax.faces.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@ManagedBean
@ViewScoped
public class MainBean {
    private List<Employee> selectedEmployees = new ArrayList<>();

    public void showEmployees(ActionEvent ae) {
        RequestContext.getCurrentInstance()
                      .openDialog("employee", getDialogOptions(), null);
    }

    public Map<String, Object> getDialogOptions() {
        Map<String, Object> options = new HashMap<>();
        options.put("resizable", false);
        options.put("draggable", true);
        options.put("modal", true);
        options.put("height", 600);
        options.put("contentHeight", "100%");
        return options;
    }

    public void onEmployeeSelected(SelectEvent selectEvent) {
        this.selectedEmployees = (List<Employee>) selectEvent.getObject();
    }

    public List<Employee> getSelectedEmployees() {
        return selectedEmployees;
    }
}