package com.logicbig.example;

import org.fluttercode.datafactory.impl.DataFactory;
import java.util.ArrayList;
import java.util.List;

public enum EmployeeService {
    Instance;
    private List<Employee> employeeList = new ArrayList<>();

    EmployeeService() {
        String[] departmentList = {"IT", "Sales", "Account", "Admin"};
        DataFactory dataFactory = new DataFactory();
        for (int i = 1; i < 50; i++) {
            Employee employee = new Employee();
            employee.setId(i);
            employee.setName(dataFactory.getName());
            employee.setPhoneNumber(String.format("%s-%s-%s", dataFactory.getNumberText(3),
                    dataFactory.getNumberText(3),
                    dataFactory.getNumberText(4)));
            employee.setDepartment(dataFactory.getItem(departmentList));
            employeeList.add(employee);
        }
        System.out.println(employeeList);
    }

    public List<Employee> getEmployees() {
        return employeeList;
    }
}