package com.logicbig.example;

import org.fluttercode.datafactory.impl.DataFactory;
import org.primefaces.context.RequestContext;
import javax.annotation.PostConstruct;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.RequestScoped;
import java.util.ArrayList;
import java.util.List;

@ManagedBean
@RequestScoped
public class EmployeeBean {
    private List<Employee> selectedEmployees;

    public List<Employee> getEmployeeList() {
        return EmployeeService.Instance.getEmployees();
    }

    public List<Employee> getSelectedEmployees() {
        return selectedEmployees;
    }

    public void setSelectedEmployees(List<Employee> selectedEmployees) {
        this.selectedEmployees = selectedEmployees;
    }

    public void submitSelectedEmployees() {
        RequestContext.getCurrentInstance().closeDialog(selectedEmployees);
    }
}