package com.logicbig.example;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public class ExampleMain3 {
    public static void main(String[] args) throws IOException {
        String jsonString = "{\"name\":null}";
        System.out.println(jsonString);
        //convert to Person
        Person person = toPerson(jsonString);
        System.out.println(person);
    }

    private static Person toPerson(String jsonData) throws IOException {
        ObjectMapper om = new ObjectMapper();
        return om.readValue(jsonData, Person.class);
    }

    private static class Person {
        private String name;

        @JsonSetter(nulls = Nulls.AS_EMPTY)
        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return name;
        }

        @Override
        public String toString() {
            return "Person{" +
                    "name='" + name + '\'' +
                    '}';
        }
    }
}