package com.logicbig.example;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public class ExampleMain {
    public static void main(String[] args) throws IOException {
        Department dept = new Department();
        dept.setDeptName("Admin");
        dept.setLocation("NY");
        Employee employee = new Employee();
        employee.setName("Amy");
        employee.setDept(dept);

        System.out.println("-- before serialization --");
        System.out.println(employee);

        System.out.println("-- after serialization --");
        ObjectMapper om = new ObjectMapper();
        String jsonString = om.writeValueAsString(employee);
        System.out.println(jsonString);

        System.out.println("-- after deserialization --");
        Employee employee2 = om.readValue(jsonString, Employee.class);
        System.out.println(employee2);
    }
}