package com.logicbig.example;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public class ExampleMain2 {
    public static void main(String[] args) throws IOException {
        Address address = new Address();
        address.setStreet("421 Sun Ave");
        address.setCity("Yellow Town");

        System.out.println("-- before conversion --");
        System.out.println(address);

        //convert to json
        System.out.println("-- to json --");
        String jsonString = toJson(address);
        System.out.println(jsonString);
        //convert to object;
        System.out.println("-- to object --");
        Address a = toAddress(jsonString);
        System.out.println(a);
    }

    private static Address toAddress(String jsonData) throws IOException {
        ObjectMapper om = new ObjectMapper();
        return om.readValue(jsonData, Address.class);
    }

    private static String toJson(Address address) throws IOException {
        ObjectMapper om = new ObjectMapper();
        return om.writeValueAsString(address);
    }
}