package com.logicbig.example;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public class ExampleMain {
    public static void main(String[] args) throws IOException {
        Address address = new Address();
        address.setStreet("421 Sun Ave");
        address.setCity("Yellow Town");
        Employee employee = new Employee();
        employee.setName("Trish");
        employee.setDept("Admin");
        employee.setAddress(address);
        System.out.println("-- before conversion --");
        System.out.println(employee);

        //convert to json
        System.out.println("-- to json --");
        String jsonString = toJson(employee);
        System.out.println(jsonString);
        //convert to object;
        System.out.println("-- to object --");
        Employee e = toEmployee(jsonString);
        System.out.println(e);

        //address will be ignore here too
        String s = "{\"name\":\"Trish\",\"dept\":\"Admin\","
                + "\"address\":{\"street\":\"421 Sun Ave\",\"city\":\"Yellow Town\"}}";
        System.out.println("raw json: "+s);
        System.out.println("-- to object --");
        Employee e2 = toEmployee(s);
        System.out.println(e2);
    }

    private static Employee toEmployee(String jsonData) throws IOException {
        ObjectMapper om = new ObjectMapper();
        return om.readValue(jsonData, Employee.class);
    }

    private static String toJson(Employee employee) throws IOException {
        ObjectMapper om = new ObjectMapper();
        return om.writeValueAsString(employee);
    }
}