package com.logicbig.example;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public class ExampleMain {
    public static void main(String[] args) throws IOException {
        String jsonString = "\"FullTime\"";
        System.out.println("-- Json string to deserialize --");
        System.out.println(jsonString);

        ObjectMapper om = new ObjectMapper();
        om.enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE);
        EmployeeType type = om.readValue(jsonString, EmployeeType.class);
        System.out.println("-- after deserialization --");
        System.out.println(type);
    }
}