package com.logicbig.example;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public class ExampleMain {
    public static void main(String[] args) throws IOException {
        ObjectMapper om = new ObjectMapper();
        System.out.println("-- deserializing --");
        String jsonData = "{\"name\":\"Trish\",\"department\":\"IT\"}";
        Employee employee = om.readValue(jsonData, Employee.class);
        System.out.println(employee);

        jsonData = "{\"name\":\"Trish\",\"employeeDept\":\"IT\"}";
        employee = om.readValue(jsonData, Employee.class);
        System.out.println(employee);

        System.out.println("-- serializing --");
        Employee e = Employee.of("Jake", "Admin");
        String s = om.writeValueAsString(e);
        System.out.println(s);
    }
}