package com.logicbig.example;


import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;

public class PojoTypeReference {
    public static void main(String[] args) throws IOException {
        toJson();
        // toPojo();
        toPojoWithTypeReference();
    }

    private static void toJson() throws JsonProcessingException {
        MyObject pojo = new MyObject();
        pojo.setIntVal(3);
        pojo.setStringVal("test string");
        pojo.setList(List.of("item1", "item2"));
        List<MyObject> list = List.of(pojo);

        ObjectMapper om = new ObjectMapper();
        String s = om.writeValueAsString(list);
        System.out.println(s);
    }

    private static void toPojo() throws IOException {
        String s = "[{\"intVal\":3,\"list\":[\"item1\",\"item2\"],\"stringVal\":\"test string\"}]";
        ObjectMapper om = new ObjectMapper();
        List<MyObject> list = om.readValue(s, List.class);
        System.out.println(list.get(0));
        System.out.println(list.get(0).getClass());
    }

    private static void toPojoWithTypeReference() throws IOException {
        String s = "[{\"intVal\":3,\"list\":[\"item1\",\"item2\"],\"stringVal\":\"test string\"}]";
        ObjectMapper om = new ObjectMapper();
        List<MyObject> list = om.readValue(s, new TypeReference<List<MyObject>>() { });
        System.out.println(list.get(0));
        System.out.println(list.get(0).getClass());
    }
}