package com.logicbig.example;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;


public class GenericsType {
    public static void main(String[] args) throws IOException {
        MyObject myObject = new MyObject();
        myObject.setIntVal(3);
        myObject.setStringVal("test String");
        myObject.setList(Arrays.asList("one", "two"));
        Map<String, MyObject> map = Map.of("myKey", myObject);

        ObjectMapper om = new ObjectMapper();
        String s = om.writeValueAsString(map);
        System.out.println(s);

        Map<String, MyObject> map2 = om.readValue(s, Map.class);
        System.out.println(map2.get("myKey"));

        Map<String, MyObject> map3 = om.readValue(s, new TypeReference<Map<String, MyObject>>(){});
        System.out.println(map3.get("myKey"));
    }
}