package com.logicbig.example;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;

public class WritingReadingFiles {
    public static void main(String[] args) throws IOException {
        readingWritingFile();
    }
    private static void readingWritingFile() throws IOException {
        MyObject myObject = new MyObject();
        myObject.setIntVal(3);
        myObject.setStringVal("test string");
        myObject.setList(List.of("item1", "item2"));

        //create temp file
        File tempFile = File.createTempFile("jackson-", ".txt");
        System.out.println("-- saving to file --");
        System.out.println(tempFile);

        //write myObject as JSON to file
        ObjectMapper om = new ObjectMapper();
        om.writeValue(tempFile, myObject);

        //reading
        System.out.println("-- reading as text from file --");
        String s = new String(Files.readAllBytes(tempFile.toPath()));
        System.out.println(s);

        System.out.println("-- reading as Object from file --");
        MyObject myObject2 = om.readValue(tempFile, MyObject.class);
        System.out.println(myObject2);
    }
}