package com.logicbig.example;


import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;

public class PojoConversion {
    public static void main(String[] args) throws IOException {
        pojoToJson();
        jsonToPojo();
    }

    private static void pojoToJson() throws JsonProcessingException {
        MyObject pojo = new MyObject();
        pojo.setIntVal(3);
        pojo.setStringVal("test string");
        pojo.setList(List.of("item1", "item2"));
        ObjectMapper om = new ObjectMapper();
        String s = om.writeValueAsString(pojo);
        System.out.println(s);
    }

    private static void jsonToPojo() throws IOException {
        String s = "{\"list\":[\"item3\",\"item4\"],\"stringVal\":\"test string2\",\"intVal\":5}";
        ObjectMapper om = new ObjectMapper();
        MyObject obj = om.readValue(s, MyObject.class);
        System.out.println(obj);
    }
}