package com.logicbig.example;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class ExampleMain {
    public static void main(String[] args) throws IOException {
        System.out.println("-- Java object to JSON (serialization) --");
        CurrencyRate cr = new CurrencyRate();
        cr.setPair("USD/JPY");
        cr.setRate(new BigDecimal(109.15).setScale(2, RoundingMode.CEILING));
        System.out.println("Java object: " + cr);

        ObjectMapper om = new ObjectMapper();
        String s2 = om.writeValueAsString(cr);
        System.out.println("JSON string: " + s2);

        System.out.println("-- JSON to Java object (deserialization) --");
        CurrencyRate cr2 = om.readValue(s2, CurrencyRate.class);
        System.out.println("Java Object: " + cr2);
        System.out.println("rate type: "+cr2.getRate().getClass());
    }
}