package com.logicbig.example;

import java.beans.ConstructorProperties;

public class Employee {
    private String name;
    private String dept;

    @ConstructorProperties({"name", "dept"})
    public Employee(String name, String dept) {
        System.out.println("Constructor invoked");
        //Java 9 StackWalker to find out the caller
        System.out.println("caller: " + StackWalker.getInstance(
                StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass());
        this.name = name;
        this.dept = dept;
    }

    public String getName() {
        return name;
    }

    public String getDept() {
        return dept;
    }

    @Override
    public String toString() {
        return "Employee{" +
                "name='" + name + '\'' +
                ", dept='" + dept + '\'' +
                '}';
    }
}