package com.logicbig.example;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public class ConstructorPropertiesExample {
    public static void main(String[] args) throws IOException {
        System.out.println("-- serializing --");
        Employee employee = new Employee("Trish", "Admin");
        //convert to json
        String jsonString = toJson(employee);
        System.out.println("serialized json: " + jsonString);

        System.out.println("-- deserializing --");
        Employee e = toEmployee(jsonString);
        System.out.println("deserialized object: " + e);
    }

    private static Employee toEmployee(String jsonData) throws IOException {
        ObjectMapper om = new ObjectMapper();
        return om.readValue(jsonData, Employee.class);
    }

    private static String toJson(Employee employee) throws IOException {
        ObjectMapper om = new ObjectMapper();
        return om.writeValueAsString(employee);
    }
}