package com.logicbig.example;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.List;


public class EnableIndentOutput {
    public static void main(String[] args) throws IOException {
        defaultOutput();
        enableIndentOutput();
    }

    private static void defaultOutput() throws JsonProcessingException {
        MyObject myObject = new MyObject(3, "test String",
                List.of("one", "two"));
        ObjectMapper om = new ObjectMapper();
        String s = om.writeValueAsString(myObject);
        System.out.println(s);
    }

    private static void enableIndentOutput() throws JsonProcessingException {
        MyObject myObject = new MyObject(3, "test String",
                List.of("one", "two"));
        ObjectMapper om = new ObjectMapper();
        om.enable(SerializationFeature.INDENT_OUTPUT);
        String s = om.writeValueAsString(myObject);
        System.out.println(s);
    }
}