package com.logicbig.example;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;

public class EnableEmptyStringAsNullPojo {
    public static void main(String[] args) throws IOException {
        defaultOutput();
        enableEmptyStringAsNull();
    }

    private static void defaultOutput() throws IOException {
        String s = "{\"myObjKey\":\"\"}";
        System.out.println("input:\n" + s);
        ObjectMapper om = new ObjectMapper();
        Map<String, MyObject> myObject = om.readValue(s, new TypeReference<Map<String, MyObject>>() { });
        System.out.println(myObject);
    }

    private static void enableEmptyStringAsNull() throws IOException {
        String s = "{\"myObjKey\":\"\"}";
        System.out.println("input:\n " + s);
        ObjectMapper om = new ObjectMapper();
        om.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        Map<String, MyObject> myObject = om.readValue(s, new TypeReference<Map<String, MyObject>>() { });
        System.out.println(myObject);
    }
}