package com.logicbig.example;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public class DisableFailOnUnknownProps {
    public static void main(String[] args) throws IOException {
        defaultOutput();
        disableFailOnUnknownProps();
    }

    private static void defaultOutput() throws IOException {
        MyObject2 myObject = new MyObject2(3);
        ObjectMapper om = new ObjectMapper();
        String s = om.writeValueAsString(myObject);
        System.out.println(s);
        myObject = om.readValue(s, MyObject2.class);
        System.out.println(myObject);
    }

    private static void disableFailOnUnknownProps() throws IOException {
        MyObject2 myObject = new MyObject2(3);
        ObjectMapper om = new ObjectMapper();
        om.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        String s = om.writeValueAsString(myObject);
        System.out.println(s);
        myObject = om.readValue(s, MyObject2.class);
        System.out.println(myObject);
    }
}