package com.logicbig.example;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;

public class DisableFailOnEmptyBeans {
    public static void main(String[] args) throws IOException {
        defaultOutput();
        disableFailOnEmptyBeans();
    }

    private static void defaultOutput() throws IOException {
        MyEmptyObject myObject = new MyEmptyObject();
        ObjectMapper om = new ObjectMapper();
        String s = om.writeValueAsString(myObject);
        System.out.println(s);
    }

    private static void disableFailOnEmptyBeans() throws IOException {
        MyEmptyObject myObject = new MyEmptyObject();
        ObjectMapper om = new ObjectMapper();
        om.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        String s = om.writeValueAsString(myObject);
        System.out.println(s);
    }
}