package com.logicbig.example;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.Date;
import java.util.Map;

public class DisableDateAsTimestamps {
    public static void main(String[] args) throws IOException {
        defaultOutput();
        disableDateAsTimestamps();
    }

    private static void defaultOutput() throws IOException {
        Date date = new Date();
        ObjectMapper om = new ObjectMapper();
        String s = om.writeValueAsString(Map.of("myDate", date));
        System.out.println(s);
    }

    private static void disableDateAsTimestamps() throws IOException {
        Date date = new Date();
        ObjectMapper om = new ObjectMapper();
        om.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        String s = om.writeValueAsString(Map.of("myDate", date));
        System.out.println(s);
    }
}