package com.logicbig.example.jtree;

import com.logicbig.example.JTreeUtil;
import javax.swing.*;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import java.awt.*;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;

public class ExampleMain {

    public static void main(String[] args) {
        JTree tree = new JTree(new Hashtable<>(createTreeData()));
        JTreeUtil.setTreeExpandedState(tree, true);
        JTreeUtil.makeTreeUnCollapsible(tree);
        JFrame frame = createFrame();
        frame.add(new JScrollPane(tree));
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    private static void expandNode(JTree tree, TreeNode node) {
        ArrayList<? extends TreeNode> list = Collections.list(node.children());
        for (TreeNode treeNode : list) {
            expandNode(tree, treeNode);
        }
        TreePath path = new TreePath(((DefaultMutableTreeNode) node).getPath());
        tree.expandPath(path);
    }

    private static Map<?, ?> createTreeData() {
        return Map.of("Sports",
                new String[]{"Mustang", "Corvette", "Ferrari"},
                "Luxury",
                new String[]{"BMW", "Mercedes-Benz", "Rolls-Royce"});
    }

    private static JFrame createFrame() {
        JFrame frame = new JFrame("Uncollapsible JTree");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setSize(new Dimension(500, 400));
        return frame;
    }
}