package com.logicbig.example;


import javax.swing.*;
import java.awt.*;
import java.util.List;

public class JListFilterExample {
    public static void main(String[] args) {
        List<Employee> employees = EmployeeDataAccess.getEmployees();
        DefaultListModel<Employee> model = new DefaultListModel<>();
        employees.forEach(model::addElement);
        JList<Employee> jList = new JList<>(model);
        jList.setCellRenderer(createListRenderer());
        JPanel panel = JListFilterDecorator.decorate(jList, JListFilterExample::employeeFilter);
        JFrame frame = createFrame();
        frame.add(panel);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    private static boolean employeeFilter(Employee emp, String str) {
        return emp.getName().toLowerCase().contains(str.toLowerCase());
    }

    private static ListCellRenderer<? super Employee> createListRenderer() {
        return new DefaultListCellRenderer() {
            private Color background = new Color(0, 100, 255, 15);
            private Color defaultBackground = (Color) UIManager.get("List.background");

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index,
                                                          boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (c instanceof JLabel) {
                    JLabel label = (JLabel) c;
                    Employee emp = (Employee) value;
                    label.setText(String.format("%s [%s]", emp.getName(), emp.getDept()));
                    if (!isSelected) {
                        label.setBackground(index % 2 == 0 ? background : defaultBackground);
                    }
                }
                return c;
            }
        };
    }

    private static JFrame createFrame() {
        JFrame frame = new JFrame("JList Example");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setSize(new Dimension(600, 300));
        return frame;
    }
}