package com.logicbig.example;


import javax.swing.*;
import java.awt.*;
import java.util.List;

public class JListHighlightedFilterExample {
    public static void main(String[] args) {
        List<Employee> employees = EmployeeDataAccess.getEmployees();
        DefaultListModel<Employee> model = new DefaultListModel<>();
        employees.forEach(model::addElement);
        JList<Employee> jList = new JList<>(model);
        JListFilterDecorator decorator = JListFilterDecorator
                .decorate(jList, JListHighlightedFilterExample::employeeFilter);
        jList.setCellRenderer(createListRenderer(decorator.getFilterField()));

        JFrame frame = createFrame();
        frame.add(decorator.getContentPanel());
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    private static boolean employeeFilter(Employee emp, String textToFilter) {
        if(textToFilter.isEmpty()){
            return true;
        }
        return getEmployeeDisplayText(emp).toLowerCase()
                                          .contains(textToFilter.toLowerCase());
        /*try {//Use following instead of the above line to support regex filtering..
            return getEmployeeDisplayText(emp).matches(textToFilter);
        } catch (Exception e) {
            return false;
        }*/
    }

    private static String getEmployeeDisplayText(Employee emp) {
        return String.format("%s [%s]", emp.getName(), emp.getDept());
    }

    private static ListCellRenderer<? super Employee> createListRenderer(JTextField filterField) {
        return new DefaultListCellRenderer() {
            private Color background = new Color(0, 100, 255, 15);
            private Color defaultBackground = (Color) UIManager.get("List.background");

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index,
                                                          boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                this.setFont(this.getFont().deriveFont(14f).deriveFont(Font.PLAIN));
                Employee emp = (Employee) value;
                String displayText = getEmployeeDisplayText(emp);
                displayText = HtmlHighlighter.highlightText(displayText, filterField.getText());
                setText(displayText);
                if (!isSelected) {
                    setBackground(index % 2 == 0 ? background : defaultBackground);
                }
                return this;
            }
        };
    }

    private static JFrame createFrame() {
        JFrame frame = new JFrame("JList Example");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setSize(new Dimension(600, 300));
        return frame;
    }
}