package com.logicbig.example;

import javax.swing.*;
import java.awt.*;

public class PaginationExampleMain {
    public static void main(String[] args) {
        JFrame frame = createFrame();
        ObjectTableModel<Employee> objectDataModel = new DisplayableObjectTableModel<>(Employee.class);
        JTable table = new JTable(objectDataModel);
        table.setAutoCreateRowSorter(true);
        PaginationDataProvider<Employee> dataProvider = createDataProvider(objectDataModel);
        PaginatedTableDecorator<Employee> paginatedDecorator = PaginatedTableDecorator.decorate(table,
                dataProvider, new int[]{5, 10, 20, 50, 75, 100}, 10);
        frame.add(paginatedDecorator.getContentPanel());
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    private static PaginationDataProvider<Employee> createDataProvider(
            ObjectTableModel<Employee> objectDataModel) {

        return new EmployeeLazyDataProvider(objectDataModel);
    }

    private static JFrame createFrame() {
        JFrame frame = new JFrame("JTable Pagination example");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setSize(new Dimension(600, 300));
        return frame;
    }
}