package com.logicbig.example;

import java.util.List;

public class EmployeeLazyDataProvider implements PaginationDataProvider<Employee> {
    private final int totalEmployeeCount;
    private final ObjectTableModel<Employee> objectTableModel;

    public EmployeeLazyDataProvider(ObjectTableModel<Employee> objectTableModel) {
        this.objectTableModel = objectTableModel;
        this.totalEmployeeCount = DataService.INSTANCE.getEmployeeTotalCount();
    }

    @Override
    public int getTotalRowCount() {
        return totalEmployeeCount;
    }

    @Override
    public List<Employee> getRows(int startIndex, int endIndex, int sortColumnIndex, boolean sortDescending) {
        String fieldName = sortColumnIndex != -1 ? objectTableModel.getFieldName(sortColumnIndex) : null;
        return DataService.INSTANCE.getEmployeeList(startIndex, endIndex - startIndex, fieldName, sortDescending);
    }
}