package com.logicbig.example;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@FacesConverter(forClass = Phone.class)
public class PhoneConverter implements Converter {
    private static final Pattern PHONE_PATTERN = Pattern.compile("(\\d{3})-(\\d{3})-(\\d{4})");

    @Override
    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        Matcher matcher = PHONE_PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw new RuntimeException(
                    String.format("invalid input: %s. The valid format is of type %s%n",
                            value, "111-111-1111"));
        }
        String areaCode = matcher.group(1);
        String exchange = matcher.group(2);
        String line = matcher.group(3);
        return new Phone(areaCode, exchange, line);
    }

    @Override
    public String getAsString(FacesContext context, UIComponent component, Object value) {
        Phone phone = (Phone) value;
        return String.format("%s-%s-%s",
                phone.getAreaCode(), phone.getExchangeCode(), phone.getLineNumber());
    }
}