package com.logicbig.example;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;
import java.util.Map;

@FacesConverter("phConverter")
public class PhoneConverter implements Converter {

    @Override
    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        Map<String, Object> attributes = component.getAttributes();
        String formatString = (String) attributes.get("format");
        Phone phone = PhoneFormat.parse(formatString, value);
        return phone;
    }

    @Override
    public String getAsString(FacesContext context, UIComponent component, Object value) {
        Phone phone = (Phone) value;
        Map<String, Object> attributes = component.getAttributes();
        String formatString = (String) attributes.get("format");
        return PhoneFormat.format(formatString, phone);
    }
}