package com.logicbig.example;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;

@FacesConverter("phConverter")
public class PhoneConverter implements Converter {
    private String format;

    @Override
    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        Phone phone = PhoneFormat.parse(format, value);
        return phone;
    }

    @Override
    public String getAsString(FacesContext context, UIComponent component, Object value) {
        Phone phone = (Phone) value;
        return PhoneFormat.format(format, phone);
    }

    public String getFormat() {
        return format;
    }

    public void setFormat(String format) {
        this.format = format;
    }
}