package com.logicbig.example;

import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;

@FacesComponent(createTag = true, tagName = "helloComponent", namespace = "http://example.com/tags")
public class HelloComponent extends UIComponentBase {
    @Override
    public String getFamily() {
        return "Greeting";
    }

    @Override
    public void encodeBegin(FacesContext context) throws IOException {
        String message = (String) getAttributes().get("message");
        LocalDateTime time = (LocalDateTime) getAttributes().get("time");
        String formattedTime = time.format(
                DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM));

        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("p", this);
        writer.write("Message: " + message);
        writer.endElement("p");

        writer.startElement("p", this);
        writer.write("Time: " + formattedTime);
        writer.endElement("p");
    }
}