package com.logicbig.example;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

@FacesValidator("empValidator")
public class EmployeeValidator implements Validator {
    private String role;

    @Override
    public void validate(FacesContext context, UIComponent component,
                         Object value) throws ValidatorException {
        String errorMessage = null;
        if (!(value instanceof Employee)) {
            errorMessage = "No employee found.";
        } else if (!((Employee) value).getRole().equalsIgnoreCase(role)) {
            errorMessage = "Employee does not have the role: " + role;
        }

        if (errorMessage != null) {
            FacesMessage msg =
                    new FacesMessage("Invalid Employee Input", errorMessage);
            msg.setSeverity(FacesMessage.SEVERITY_ERROR);
            throw new ValidatorException(msg);
        }
    }

    public String getRole() {
        return role;
    }

    public void setRole(String role) {
        this.role = role;
    }
}