package com.logicbig.example;

import java.util.ArrayList;
import java.util.List;

public enum EmployeeService {
    Instance;
    private List<Employee> list = new ArrayList<>();

    EmployeeService(){
        list.add(new Employee(100, "Sara", "Admin", "Manager"));
        list.add(new Employee(200, "Mike", "IT", "Developer"));
    }

    public Employee findById(String idString) {
        try {
            long id = Long.parseLong(idString);
            return list.stream()
                       .filter(e -> e.getId() == id)
                       .findAny()
                       .orElse(null);
        } catch (NumberFormatException e) {
            return null;
        }
    }

    public Employee findByName(String name) {
        return list.stream()
                   .filter(e -> e.getName().equals(name))
                   .findAny()
                   .orElse(null);
    }
}