package com.logicbig.example;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;

@FacesConverter("empConverter")
public class EmployeeConverter implements Converter {
    private String by;

    @Override
    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        if ("name".equalsIgnoreCase(by)) {
            return EmployeeService.Instance.findByName(value);
        } else if ("id".equalsIgnoreCase(by)) {
            return EmployeeService.Instance.findById(value);
        }
        return null;
    }

    @Override
    public String getAsString(FacesContext context, UIComponent component, Object value) {
        Employee employee = (Employee) value;
        if ("name".equals(by)) {
            return employee.getName();
        } else if ("id".equals(by)) {
            return Long.toString(employee.getId());
        }
        return null;
    }

    public String getBy() {
        return by;
    }

    public void setBy(String by) {
        this.by = by;
    }
}