package com.logicbig.example;

import javax.persistence.*;
import java.util.Arrays;
import java.util.List;

public class ExampleMain {
    private static EntityManagerFactory entityManagerFactory =
            Persistence.createEntityManagerFactory("example-unit");

    public static void main(String[] args) {
        try {
            //constraint assigned to Employee table:
            runNativeQuery("SELECT * FROM INFORMATION_SCHEMA.CONSTRAINTS WHERE TABLE_NAME='EMPLOYEE'");
            //column names of CONSTRAINTS table:
            runNativeQuery("SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME='CONSTRAINTS'");
            persistEmployees();
            findAllEmployees();
        } finally {
            entityManagerFactory.close();
        }
    }

    private static void findAllEmployees() {
        System.out.println("-- Employees with phone number NOT 222-222-222 --");
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        TypedQuery<Employee> query = entityManager
                .createQuery("Select e from Employee e", Employee.class);
        List<Employee> list = query.getResultList();
        list.forEach(System.out::println);
        entityManager.close();
    }

    private static void runNativeQuery(String s) {
        System.out.printf("-- %s --%n", s);
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        Query query = entityManager.createNativeQuery(s);
        List list = query.getResultList();
        for (Object o : list) {
            if (o instanceof Object[]) {
                System.out.println(Arrays.toString((Object[]) o));
            } else {
                System.out.println(o);
            }
        }
    }

    public static void persistEmployees() {
        Employee employee1 = Employee.of("Diana", "IT");
        Employee employee2 = Employee.of("Mike", "Admin");
        Employee employee3 = Employee.of("Tim", "Sales");

        EntityManager em = entityManagerFactory.createEntityManager();
        em.getTransaction().begin();
        em.persist(employee1);
        em.persist(employee2);
        em.persist(employee3);
        em.getTransaction().commit();
        em.close();
    }
}