package com.logicbig.example;

import javax.persistence.*;

@Entity
@Table(uniqueConstraints = {
        @UniqueConstraint(columnNames = "name", name = "uniqueNameConstraint")}
)
public class Employee {
    @Id
    @GeneratedValue
    private long id;
    private String name;
    private String dept;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDept() {
        return dept;
    }

    public void setDept(String dept) {
        this.dept = dept;
    }

    public static Employee of(String name, String dept) {
        Employee e = new Employee();
        e.name = name;
        e.dept = dept;
        return e;
    }

    @Override
    public String toString() {
        return "Employee{" +
                "id=" + id +
                ", name='" + name + '\'' +
                ", dept='" + dept + '\'' +
                '}';
    }
}