package com.logicbig.example;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;

@Entity
public class Person {
    @Id
    @GeneratedValue
    private int id;
    private String name;
    private Byte age;
    private boolean registeredVoter;

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Byte getAge() {
        return age;
    }

    public void setAge(Byte age) {
        this.age = age;
    }

    public boolean isRegisteredVoter() {
        return registeredVoter;
    }

    public void setRegisteredVoter(boolean registeredVoter) {
        this.registeredVoter = registeredVoter;
    }

    public static Person of(String name, Byte age, boolean voter){
        Person p = new Person();
        p.name = name;
        p.age = age;
        p.registeredVoter = voter;
        return p;
    }

    @Override
    public String toString() {
        return "Person{" +
                "id=" + id +
                ", name='" + name + '\'' +
                ", age=" + age +
                ", registeredVoter=" + registeredVoter +
                '}';
    }
}