package com.logicbig.example;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import java.util.Arrays;
import java.util.List;

public class ExampleMain {
    private static EntityManagerFactory entityManagerFactory =
            Persistence.createEntityManagerFactory("example-unit");

    public static void main(String[] args) {
        try {
            persistEmployees();
            findEmployees();
            findEmployees2();

        } finally {
            entityManagerFactory.close();
        }
    }

    private static void findEmployees() {
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery<Employee> criteriaQuery = criteriaBuilder.createQuery(Employee.class);
        Root<Employee> root = criteriaQuery.from(Employee.class);
        criteriaQuery.select(root);

        System.out.println("-- All employees --");
        List<Employee> resultList = entityManager.createQuery(criteriaQuery).getResultList();
        resultList.forEach(System.out::println);


        System.out.println("-- All employees from IT dept --");
        criteriaQuery.where(criteriaBuilder.equal(root.get(Employee_.DEPT), "IT"));
        List<Employee> resultList2 = entityManager.createQuery(criteriaQuery).getResultList();
        resultList2.forEach(System.out::println);

        entityManager.close();
    }

    private static void findEmployees2() {
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery<Object[]> criteriaQuery = criteriaBuilder.createQuery(Object[].class);
        Root<Employee> root = criteriaQuery.from(Employee.class);

        System.out.println("-- Employees name and salary --");
        criteriaQuery.multiselect(root.get(Employee_.NAME), root.get(Employee_.SALARY));
        List<Object[]> resultList = entityManager.createQuery(criteriaQuery).getResultList();
        resultList.forEach(arr -> System.out.println(Arrays.toString(arr)));

        System.out.println("-- Employees name and dept --");
        criteriaQuery.multiselect(root.get(Employee_.NAME), root.get(Employee_.DEPT));
        List<Object[]> resultList2 = entityManager.createQuery(criteriaQuery).getResultList();
        resultList2.forEach(arr -> System.out.println(Arrays.toString(arr)));

        entityManager.close();
    }


    public static void persistEmployees() {
        Employee employee1 = Employee.create("Diana", 2000, "IT");
        Employee employee2 = Employee.create("Rose", 3500, "Admin");
        Employee employee3 = Employee.create("Denise", 2500, "Admin");
        Employee employee4 = Employee.create("Mike", 4000, "IT");
        Employee employee5 = Employee.create("Linda", 4500, "Sales");
        EntityManager em = entityManagerFactory.createEntityManager();
        em.getTransaction().begin();
        em.persist(employee1);
        em.persist(employee2);
        em.persist(employee3);
        em.persist(employee4);
        em.persist(employee5);
        em.getTransaction().commit();
        em.close();
    }
}