package com.logicbig.example;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExampleMain2 {

    public static void main(String[] args) {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("example-unit");
        try {
            persistEntity(emf);
            runNativeQueries(emf);
            loadEntity(emf);
        } finally {
            emf.close();
        }
    }

    private static void persistEntity(EntityManagerFactory emf) {
        System.out.println("-- Persisting entities --");
        EntityManager em = emf.createEntityManager();

        Customer c1 = new Customer();
        c1.setName("Lindsey Craft");
        Map<String, Integer> itemPurchased = new HashMap<>();
        itemPurchased.put("XYZ Blender", 1);
        itemPurchased.put("ZZZ Beer Glass", 4);
        c1.setItemQtyMap(itemPurchased);
        System.out.println(c1);

        Customer c2 = new Customer();
        c2.setName("Morgan Philips");
        Map<String, Integer> orderMap2 = new HashMap<>();
        orderMap2.put("AA Glass Cleaner",3);
        c2.setItemQtyMap(orderMap2);
        System.out.println(c2);

        em.getTransaction().begin();
        em.persist(c1);
        em.persist(c2);
        em.getTransaction().commit();
        em.close();
    }

    private static void runNativeQueries(EntityManagerFactory emf) {
        System.out.println("-- Native queries --");
        EntityManager em = emf.createEntityManager();
        ExampleMain.nativeQuery(em, "Select * from Customer");
        ExampleMain.nativeQuery(em, "Select * from Customer_ItemQtyMap");
    }

    private static void loadEntity(EntityManagerFactory emf) {
        System.out.println("-- Loading Customer --");
        EntityManager em = emf.createEntityManager();
        List<Customer> entityAList = em.createQuery("Select t from Customer t")
                                       .getResultList();
        entityAList.forEach(System.out::println);
        em.close();
    }
}