package com.logicbig.example;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import java.util.Arrays;
import java.util.List;

public class ExampleMain2 {
    private static EntityManagerFactory entityManagerFactory =
            Persistence.createEntityManagerFactory("example-unit");

    public static void main(String[] args) {
        try {
            persistEmployees();
            nativeQuery("Select * FROM Employee");
            nativeQuery("Select * FROM Employee_PhoneNumbers");
        } finally {
            entityManagerFactory.close();
        }
    }

    public static void persistEmployees() {
        Employee employee1 = Employee.create("Diana", 2000, "IT",
                 "111-111,111", "222-222,222");
        Employee employee2 = Employee.create("Denise", 2500, "Admin",
                "333-333-333", "444-444-444", "666-666-666");
        Employee employee3 = Employee.create("Linda", 4500, "Sales",
                "555-555-555");
        EntityManager em = entityManagerFactory.createEntityManager();
        em.getTransaction().begin();
        em.persist(employee1);
        em.persist(employee2);
        em.persist(employee3);
        em.getTransaction().commit();
    }

    public static void nativeQuery(String s) {
        EntityManager em = entityManagerFactory.createEntityManager();
        System.out.printf("'%s'%n", s);
        Query query = em.createNativeQuery(s);
        List list = query.getResultList();
        for (Object o : list) {
            if (o instanceof Object[]) {
                System.out.println(Arrays.toString((Object[]) o));
            } else {
                System.out.println(o);
            }
        }
        em.close();
    }
}