package com.logicbig.example;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import java.util.Arrays;
import java.util.List;

public class ExampleMain {
    private static EntityManagerFactory entityManagerFactory =
            Persistence.createEntityManagerFactory("example-unit");

    public static void main(String[] args) {
        try {
            persistEmployees();
            findEmployees();

        } finally {
            entityManagerFactory.close();
        }
    }

    public static void persistEmployees() {
        Task task1 = Task.create("Development");
        Task task2 = Task.create("Documentation");
        Task task3 = Task.create("Designing");
        Task task5 = Task.create("Refactoring");
        Task task6 = Task.create("Testing");

        Employee employee1 = Employee.create("Diana", Arrays.asList(task1, task2, task6),
                Arrays.asList(Address.create("111 Round Drive", "Papineau", "Sundland"),
                        Address.create("2623  Elmwood Avenue", "Scottsdale", "Zwonga")),
                "111-111-111", "666-666-666", "222-222-222");
        Employee employee2 = Employee.create("Denise", Arrays.asList(task2, task3),
                Arrays.asList(Address.create("23 Estate Avenue", "Papineau", "Ugrela"),
                        Address.create("367 Rose Route", "Scottsdale", "Mreyton")),
                "444-444-444", "333-333-333");
        Employee employee3 = Employee.create("Linda", Arrays.asList(task1, task5),
                Arrays.asList(Address.create("345 Little Way", "Fries", "Tospus"),
                        Address.create("91 Vine Lane", "Binesville", "Oblijan")),
                "555-555-555");
        EntityManager em = entityManagerFactory.createEntityManager();

        task1.setSupervisor(employee2);
        task2.setSupervisor(employee1);
        task3.setSupervisor(employee3);
        task5.setSupervisor(employee1);
        task6.setSupervisor(employee3);

        em.getTransaction().begin();
        em.persist(employee1);
        em.persist(employee2);
        em.persist(employee3);
        em.getTransaction().commit();
    }

    private static void findEmployees() {
        EntityManager em = entityManagerFactory.createEntityManager();
        List<Employee> employees = em.createQuery("Select e from Employee e")
                                .getResultList();
        for (Employee employee : employees) {
            System.out.println("---");
            System.out.println(employee);
            System.out.println("-- Tasks --");
            for (Task task : employee.getTasks()) {
                System.out.println("task: " + task);
                System.out.println("supervisor: " + task.getSupervisor());
            }
            System.out.println("-- addresses --");
            employee.getAddresses().forEach(System.out::println);
        }
    }
}