package com.logicbig.example;

import javax.persistence.*;
import java.util.Arrays;
import java.util.List;

@Entity
public class Employee {
    @Id
    @GeneratedValue
    private long id;
    private String name;

    @ElementCollection
    @OrderBy//order by strings
    private List<String> phoneNumbers;

    @ManyToMany(cascade = CascadeType.ALL)
    @OrderBy("supervisor")//order by task.supervisor (employee.id)
    private List<Task> tasks;

    @ElementCollection
    @OrderBy("city.country DESC")//desc order by address.city.country
    private List<Address> addresses;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getPhoneNumbers() {
        return phoneNumbers;
    }

    public void setPhoneNumbers(List<String> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    public List<Task> getTasks() {
        return tasks;
    }

    public void setTasks(List<Task> tasks) {
        this.tasks = tasks;
    }

    public List<Address> getAddresses() {
        return addresses;
    }

    public void setAddresses(List<Address> addresses) {
        this.addresses = addresses;
    }

    public static Employee create(String name, List<Task> tasks,
                                  List<Address> addresses,
                                  String... phones) {
        Employee e = new Employee();
        e.setName(name);
        e.setTasks(tasks);
        e.setPhoneNumbers(Arrays.asList(phones));
        e.setAddresses(addresses);
        return e;
    }

    @Override
    public String toString() {
        return "Employee{" +
                "id=" + id +
                ", name='" + name + '\'' +
                ", phoneNumbers=" + phoneNumbers +
                '}';
    }
}