package com.logicbig.example;

import javax.persistence.Embeddable;
import javax.persistence.Embedded;

@Embeddable
public class Address {
    private String street;
    @Embedded
    private City city;

    public String getStreet() {
        return street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public City getCity() {
        return city;
    }

    public void setCity(City city) {
        this.city = city;
    }

    public static Address create(String street, String cityName, String country) {
        Address a = new Address();
        a.setStreet(street);
        City c = new City();
        c.setName(cityName);
        c.setCountry(country);
        a.setCity(c);
        return a;
    }


    @Override
    public String toString() {
        return "Address{" +
                "street='" + street + '\'' +
                ", city=" + city +
                '}';
    }
}