package com.logicbig.example;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import java.util.Arrays;

public class ExampleMain {

    static EntityManagerFactory emf =
            Persistence.createEntityManagerFactory("example-unit");

    public static void main(String[] args) {
        Employee employee = new Employee("Sara Dorsey", "Admin");
        persistEmployee(employee);
        //employee at this point is detached but still has database id
        employee.setDepartment("Account");
        //merging
        updateEmployee(employee);
        //loading
        Employee employee2 = loadEmployeeById(employee.getId());
        print("Employee loaded", employee2);
        //creating new updated instance
        Employee employee3 = new Employee(employee.getId(), employee.getName(), "Sales");
        //merging
        updateEmployee(employee3);
        //loading again
        Employee employee4 = loadEmployeeById(employee.getId());
        print("Employee loaded", employee4);

        emf.close();
    }

    private static Employee loadEmployeeById(int id) {
        System.out.println("-- loading employee by id --");
        EntityManager em = emf.createEntityManager();
        return em.find(Employee.class, id);
    }

    private static void updateEmployee(Employee employee) {
        System.out.println("-- merging employee --");
        EntityManager em = emf.createEntityManager();
        em.getTransaction().begin();
        em.merge(employee);
        em.getTransaction().commit();
        print("Employee merged", employee);
    }

    private static void persistEmployee(Employee employee) {
        System.out.println("-- persisting employee --");
        EntityManager em = emf.createEntityManager();
        em.getTransaction().begin();
        em.persist(employee);
        em.getTransaction().commit();
        em.close();
        print("Employee persisted", employee);
    }

    private static void print(String msg, Object... objects) {
        System.out.printf("%s: %s%n", msg, Arrays.asList(objects));
    }
}