package com.logicbig.example;

import javax.persistence.*;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.Root;
import java.util.Map;

public class ExampleMain {

    public static void main(String[] args) {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("example-unit");
        try {
            persistEntity(emf);
            findItemQty(emf);
            findOrderMapEntry(emf);
        } finally {
            emf.close();
        }
    }

    private static void persistEntity(EntityManagerFactory emf) {
        System.out.println("-- Persisting entities --");
        EntityManager em = emf.createEntityManager();

        Customer c1 = new Customer();
        c1.setName("Lindsey Craft");
        c1.addOrder("online", "XYZ Blender", 2);
        c1.addOrder("store", "ZZZ Beer Glass", 4);
        System.out.println(c1);

        Customer c2 = new Customer();
        c2.setName("Morgan Philips");
        c2.addOrder("online", "AA Glass Cleaner", 3);
        System.out.println(c2);

        em.getTransaction().begin();
        em.persist(c1);
        em.persist(c2);
        em.getTransaction().commit();
        em.close();
    }

    private static void findItemQty(EntityManagerFactory emf) {
        System.out.println("-- Finding items and keys --");
        EntityManager entityManager = emf.createEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery<Tuple> query = criteriaBuilder.createTupleQuery();
        Root<Customer> customer = query.from(Customer.class);
        MapJoin<Customer, String, Order> orderMap = customer.join(Customer_.orderMap);
        query.multiselect(customer.get(Customer_.name), orderMap.key(),
                orderMap.value().get(Order_.item), orderMap.value().get(Order_.qty));
        TypedQuery<Tuple> typedQuery = entityManager.createQuery(query);
        typedQuery.getResultList().forEach(
                t -> System.out.printf("Customer: %s, Order-Type: %s, Order-item: %s, Order-qty: %s%n",
                        t.get(0), t.get(1), t.get(2), t.get(3)));
    }

    private static void findOrderMapEntry(EntityManagerFactory emf) {
        System.out.println("-- Finding orderType/order entries  --");
        EntityManager entityManager = emf.createEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery<Map.Entry> query = criteriaBuilder.createQuery(Map.Entry.class);
        Root<Customer> customer = query.from(Customer.class);
        MapJoin<Customer, String, Order> orderMap = customer.join(Customer_.orderMap);
        query.select(orderMap.entry());
        TypedQuery<Map.Entry> typedQuery = entityManager.createQuery(query);
        typedQuery.getResultList()
                  .forEach(entry -> {System.out.printf("%s = %s%n", entry.getKey(), entry.getValue());});
    }
}