package com.logicbig.example;

import javax.persistence.*;
import java.util.HashMap;
import java.util.Map;

@Entity
public class Customer {
    @Id
    @GeneratedValue
    private int id;
    private String name;
    @OneToMany(cascade = CascadeType.ALL)
    private Map<String, Order> orderMap;//orderType to Order map

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, Order> getOrderMap() {
        return orderMap;
    }

    public void setOrderMap(Map<String, Order> orderMap) {
        this.orderMap = orderMap;
    }

    public void addOrder(String orderType, String itemName, int qty) {
        if (orderMap == null) {
            orderMap = new HashMap<>();
        }
        Order order = new Order();
        order.setItem(itemName);
        order.setQty(qty);
        orderMap.put(orderType, order);
    }


    @Override
    public String toString() {
        return "Customer{" +
                "id=" + id +
                ", name='" + name + '\'' +
                ", orderMap=" + orderMap +
                '}';
    }
}