package com.logicbig.example;

import javax.persistence.*;
import java.util.List;

public class ExampleMain {
    private static EntityManagerFactory entityManagerFactory =
            Persistence.createEntityManagerFactory("example-unit");

    public static void main(String[] args) {
        try {
            persistEmployees();
            findEmployeeSalaries();


        } finally {
            entityManagerFactory.close();
        }
    }

    public static void persistEmployees() {
        Employee employee1 = Employee.create("Diana", 3000, "IT");
        Employee employee2 = Employee.create("Rose", 4000, "Admin");
        Employee employee3 = Employee.create("Denise", 1500, "Sales");
        Employee employee4 = Employee.create("Mike", 2000, "IT");
        EntityManager em = entityManagerFactory.createEntityManager();
        em.getTransaction().begin();
        em.persist(employee1);
        em.persist(employee2);
        em.persist(employee3);
        em.persist(employee4);
        em.getTransaction().commit();
        em.close();
    }

    private static void findEmployeeSalaries() {
        System.out.println("-- Employee names and salaries --");
        EntityManager em = entityManagerFactory.createEntityManager();
        TypedQuery<Tuple> query = em.createQuery("SELECT e.name, e.salary FROM Employee e", Tuple.class);
        List<Tuple> resultList = query.getResultList();
        resultList.forEach(tuple -> System.out.printf("name: %s, salary: %s%n", tuple.get(0),
                tuple.get(1, Long.class)));

    }
}