package com.logicbig.example;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import java.util.List;

public class ExampleMain {
    private static EntityManagerFactory entityManagerFactory =
            Persistence.createEntityManagerFactory("example-unit");

    public static void main(String[] args) {
        try {
            persistEmployees();
            findEmployeeFullName();
            findLongestNamedEmployee();
            findAllCities();
            findByCity();
            findByDept();
        } finally {
            entityManagerFactory.close();
        }
    }

    public static void persistEmployees() {
        Employee employee1 = Employee.create("Diana", "John", "IT", "111 Round Drive, Sunland");
        Employee employee2 = Employee.create("Rose", "Burgess", "Admin", "2623  Elmwood Avenue, Scottsdale");
        Employee employee3 = Employee.create("Denise", "Clarkson", "admin", "4000 Johnny Lane, Mars Town");
        Employee employee4 = Employee.create("Mike", "Young", "IT", "323 Tik Tok Road, Hiland");
        Employee employee5 = Employee.create("Linda", "McDonald", "Sales", "2000 Wet Road, Sunland");
        EntityManager em = entityManagerFactory.createEntityManager();
        em.getTransaction().begin();
        em.persist(employee1);
        em.persist(employee2);
        em.persist(employee3);
        em.persist(employee4);
        em.persist(employee5);
        em.getTransaction().commit();

        System.out.println("-- Employees persisted --");
        Query query = em.createQuery(
                "SELECT e FROM Employee e");
        List<Employee> resultList = query.getResultList();
        resultList.forEach(System.out::println);
        em.close();
    }

    private static void findEmployeeFullName() {
        System.out.println("-- Employees full names --");
        EntityManager em = entityManagerFactory.createEntityManager();
        Query query = em.createQuery(
                "SELECT CONCAT(e.firstName, ' ', e.lastName)  FROM Employee e");
        List<String> resultList = query.getResultList();
        resultList.forEach(System.out::println);
        em.close();
    }

    private static void findLongestNamedEmployee() {
        System.out.println("-- Find employee having the longest full name name --");
        EntityManager em = entityManagerFactory.createEntityManager();
        Query query = em.createQuery(
                "SELECT e FROM Employee e where "
                        + "LENGTH(CONCAT(e.firstName, ' ', e.lastName)) = "
                        + "(SELECT MAX(LENGTH(CONCAT(e2.firstName, ' ', e2.lastName))) FROM  Employee e2)");
        List<Employee> resultList = query.getResultList();
        resultList.forEach(System.out::println);
        em.close();
    }


    private static void findAllCities() {
        System.out.println("-- All Cities --");
        EntityManager em = entityManagerFactory.createEntityManager();
        Query query = em.createQuery(
                "SELECT DISTINCT TRIM(SUBSTRING(e.address, LOCATE(',', e.address)+1)) as city"
                        + " FROM Employee e order by city");
        List<String> resultList = query.getResultList();
        resultList.forEach(System.out::println);
        em.close();
    }

    private static void findByCity() {
        System.out.println("-- Find By City 'Sunland' --");
        EntityManager em = entityManagerFactory.createEntityManager();
        Query query = em.createQuery(
                "SELECT e FROM Employee e WHERE TRIM(SUBSTRING(e.address, LOCATE(',', e.address)+1))='Sunland'");
        List<Employee> resultList = query.getResultList();
        resultList.forEach(System.out::println);
        em.close();
    }

    private static void findByDept() {
        System.out.println("-- Find By Dept 'Admin' --");
        EntityManager em = entityManagerFactory.createEntityManager();
        Query query = em.createQuery(
                "SELECT e FROM Employee e WHERE LOWER(e.dept)='admin'");
        List<Employee> resultList = query.getResultList();
        resultList.forEach(System.out::println);
        em.close();
    }
}