package com.logicbig.example;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import java.util.ArrayList;
import java.util.List;

public class ExampleMain2 {

    public static void main(String[] args) throws Exception {
        EntityManagerFactory emf =
                Persistence.createEntityManagerFactory("example-unit");
        try {
            persistEntities(emf);
            runTypeEqualsQuery(emf);
            runTypeInQuery(emf);
            runTypeNotInQuery(emf);
        } finally {
            emf.close();
        }
    }

    private static void persistEntities(EntityManagerFactory emf) throws Exception {
        System.out.println("-- Persisting entities --");
        EntityManager em = emf.createEntityManager();
        em.getTransaction().begin();
        for (Employee employee : createEmployees()) {
            em.persist(employee);
        }
        em.getTransaction().commit();
    }

    private static void runTypeEqualsQuery(EntityManagerFactory emf) {
        System.out.println("-- running TYPE with '=' query --");
        EntityManager em = emf.createEntityManager();
        List<Employee> entityAList = em.createQuery("SELECT t FROM Employee t WHERE TYPE(t) = FullTimeEmployee")
                                       .getResultList();
        entityAList.forEach(System.out::println);
        em.close();
    }

    private static void runTypeInQuery(EntityManagerFactory emf) {
        System.out.println("-- running TYPE with 'IN' query --");
        EntityManager em = emf.createEntityManager();
        List<Employee> entityAList =
                em.createQuery("SELECT t FROM Employee t WHERE TYPE(t) IN (ContractEmployee, PartTimeEmployee)")
                  .getResultList();
        entityAList.forEach(System.out::println);
        em.close();
    }

    private static void runTypeNotInQuery(EntityManagerFactory emf) {
        System.out.println("-- running TYPE NOT 'IN' query --");
        EntityManager em = emf.createEntityManager();
        List<Employee> entityAList =
                em.createQuery("SELECT t FROM Employee t WHERE TYPE(t) NOT IN (ContractEmployee, PartTimeEmployee)")
                  .getResultList();
        entityAList.forEach(System.out::println);
        em.close();
    }


    private static List<Employee> createEmployees() {
        List<Employee> list = new ArrayList<>();
        FullTimeEmployee e = new FullTimeEmployee();
        e.setName("Sara");
        e.setSalary(100000);
        list.add(e);

        e = new FullTimeEmployee();
        e.setName("Mike");
        e.setSalary(90000);
        list.add(e);

        PartTimeEmployee e2 = new PartTimeEmployee();
        e2.setName("Jon");
        e2.setWeeklySalary(900);
        list.add(e2);

        e2 = new PartTimeEmployee();
        e2.setName("Jackie");
        e2.setWeeklySalary(1200);
        list.add(e2);

        ContractEmployee e3 = new ContractEmployee();
        e3.setName("Tom");
        e3.setHourlyRate(60);
        list.add(e3);

        e3 = new ContractEmployee();
        e3.setName("Aly");
        e3.setHourlyRate(90);
        list.add(e3);
        return list;
    }
}