package com.logicbig.example;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import java.util.ArrayList;
import java.util.List;

public class ExampleMain {

    public static void main(String[] args) throws Exception {
        EntityManagerFactory emf =
                Persistence.createEntityManagerFactory("example-unit");
        try {
            persistEntities(emf);
            runQuery(emf);
            runQuery2(emf);
        } finally {
            emf.close();
        }
    }

    private static void persistEntities(EntityManagerFactory emf) throws Exception {
        System.out.println("-- Persisting entities --");
        EntityManager em = emf.createEntityManager();
        em.getTransaction().begin();
        for (Employee employee : createEmployees()) {
            em.persist(employee);
        }
        em.getTransaction().commit();
    }

    private static void runQuery(EntityManagerFactory emf) {
        System.out.println("-- running query for Employee --");
        EntityManager em = emf.createEntityManager();
        List<Employee> entityAList = em.createQuery("SELECT t FROM Employee t")
                                       .getResultList();
        entityAList.forEach(System.out::println);
        em.close();
    }

    private static void runQuery2(EntityManagerFactory emf) {
        System.out.println("-- running query for ContractEmployee --");
        EntityManager em = emf.createEntityManager();
        List<Employee> entityAList = em.createQuery("SELECT t FROM ContractEmployee t")
                                       .getResultList();
        entityAList.forEach(System.out::println);
        em.close();
    }

    private static List<Employee> createEmployees() {
        List<Employee> list = new ArrayList<>();
        FullTimeEmployee e = new FullTimeEmployee();
        e.setName("Sara");
        e.setSalary(100000);
        list.add(e);

        e = new FullTimeEmployee();
        e.setName("Mike");
        e.setSalary(90000);
        list.add(e);

        PartTimeEmployee e2 = new PartTimeEmployee();
        e2.setName("Jon");
        e2.setWeeklySalary(900);
        list.add(e2);

        e2 = new PartTimeEmployee();
        e2.setName("Jackie");
        e2.setWeeklySalary(1200);
        list.add(e2);

        ContractEmployee e3 = new ContractEmployee();
        e3.setName("Tom");
        e3.setHourlyRate(60);
        list.add(e3);

        e3 = new ContractEmployee();
        e3.setName("Aly");
        e3.setHourlyRate(90);
        list.add(e3);
        return list;
    }
}