package com.logicbig.example;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

@Entity
public class ScheduledEvent {
    @Id
    @GeneratedValue
    private long id;
    private String eventName;
    private Date date;
    private Time start;
    private Time end;
    private Timestamp eventCreated;

    public String getEventName() {
        return eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Time getStart() {
        return start;
    }

    public void setStart(Time start) {
        this.start = start;
    }

    public Time getEnd() {
        return end;
    }

    public void setEnd(Time end) {
        this.end = end;
    }

    public Timestamp getEventCreated() {
        return eventCreated;
    }

    public void setEventCreated(Timestamp eventCreated) {
        this.eventCreated = eventCreated;
    }

    public static ScheduledEvent create(String name, LocalDate date, LocalTime start, LocalTime end,
                                        LocalDateTime eventCreated) {
        ScheduledEvent se = new ScheduledEvent();
        se.setEventName(name);
        se.setDate(Date.valueOf(date));
        se.setStart(Time.valueOf(start));
        se.setEnd(Time.valueOf(end));
        se.setEventCreated(Timestamp.valueOf(eventCreated));
        return se;
    }

    @Override
    public String toString() {
        return "ScheduledEvent{" +
                "id=" + id +
                ", eventName='" + eventName + '\'' +
                ", date=" + date +
                ", start=" + start +
                ", end=" + end +
                ", eventCreated=" + eventCreated +
                '}';
    }
}